﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        private SchoolBL _SchoolBL = null;

        public SchoolBL School
        {
            get
            {
                if (_SchoolBL == null)
                {
                    _SchoolBL = new SchoolBL(this);
                }

                return _SchoolBL;
            }
        }

        public class SchoolBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>, Gemini.Core.BL.Interface.IBORestoreByID
        {
            public SchoolBL(ZSBELearning BL) : base(BL) { }

            public Gemini.Core.BL.Base.MethodResult Delete()
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {
                    BLP.DAL.School.Delete();
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(_exception);
                }
                return _methodResult;
            }

            public int Count()
            {
                return BLP.DAL.School.Count();
            }
            
            public List<BO.School> Restore()
            {
                BO.School.Search _search = new BO.School.Search();
                return BLP.DAL.School.Restore(_search);
            }

            public List<BO.School> Restore(BO.School.Search Search)
            {
                return BLP.DAL.School.Restore(Search);
            }

            public BO.School Restore(long? ID)
            {
                BO.School _School = null;

                if (ID.HasValue)
                {
                    _School = BLP.DAL.School.Restore(ID);
                }

                return _School;
            }

            public BO.School Restore(BO.Class Class)
            {
                BO.School _School = null;

                if (Class != null && Class.SchoolID.HasValue)
                {
                    _School = BLP.DAL.School.Restore(Class.SchoolID);
                }

                return _School;
            }

            public BO.School Restore(BO.Instructor Instructor)
            {
                BO.School _School = null;

                if (Instructor != null && Instructor.SchoolID.HasValue)
                {
                    _School = BLP.DAL.School.Restore(Instructor.SchoolID);
                }

                return _School;
            }

            public Gemini.Core.BL.Base.MethodResult Save(BO.School School)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {
                    if (School == null)
                    {
                        _methodResult.SetSuccess = false;
                    }
                    else
                    {
                        if (School.ID.HasValue)
                        {
                            _methodResult.SetSuccess = BLP.DAL.School.Update(School);
                            if (_methodResult.Success)
                            {
                                BLP.APIEduFarma.SyncSchoolSave(School);
                            }
                        }
                        else
                        {
                            _methodResult.SetSuccess = BLP.DAL.School.Create(School);
                            if (_methodResult.Success)
                            {
                                BLP.APIEduFarma.SyncSchoolAdd(School);
                            }
                        }
                    }
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(_exception);
                }
                return _methodResult;
            }

            public BO.School New()
            {
                return BLP.DAL.School.New();
            }

            public Gemini.Core.BL.Base.MethodResult Remove(BO.School School)
            {
                Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                try
                {
                    if (BLP.Class.Count(School) > 0)
                    {
                        _methodResult.Add(ELearning.BL.Dictionary.Text.School.RemoveFailedClassExist.Value, false);
                    }
                    else
                    {
                        _methodResult.SetSuccess = BLP.DAL.School.Remove(School);

                        if (_methodResult.Success)
                        {
                            BLP.APIEduFarma.SyncSchoolDelete(School);
                        }
                    }
                }
                catch (Exception _exception)
                {
                    _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Exception.Value,_exception);
                }
                return _methodResult;
            }

            public BO.School Restore(Gemini.Core.BL.Interface.BO.IBaseUnique<long?> BO)
            {
                BO.School _School = null;

                if ((BO != null) && (BO.ID.HasValue))
                {
                    _School = Restore(BO.ID);
                }

                return _School;
            }

            Gemini.Core.BL.Interface.BO.IBaseUnique<long?> Gemini.Core.BL.Interface.IBORestoreByID.RestoreByID(long? ID)
            {
                Gemini.Core.BL.Interface.BO.IBaseUnique<long?> _school = null;

                if (ID.HasValue)
                {
                    _school = Restore(ID);
                }

                return _school;
            }
        }
    }
}
